--[[---------------------------------------------------------------------------
	Chocolatier Two Ledger: Badge
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

--local moneyFont = { standardFontName, kThirtyTwo, BlackColor }
local moneyFont = { standardFontName, kThirty, BlackColor }
local statusFont = { standardFontName, kSixteen, BlackColor }

local badgeWidth = 162
local badgeHeight = 106

local medals = {}
for i,m in ipairs(Simulator._Medals) do
	if gSim.medals[m.name] then
		table.insert(medals, Bitmap { x=m.x,y=m.y, image="image/medal_"..tostring(i) })
		if gNewMedal and gNewMedal == m.name then
			table.insert(medals, Sprite { x=m.mx,y=m.my, image="glitz/sparkle.xml" })
			gNewMedal = nil
		end
		table.insert(medals, MedalRollover(i))
	end
end

-- For testing only
--local noQuestWeeks = "#<outline color='ffffff'>Quest Timer:"..tostring(gSim.weeks - gSim.questWeek)

MakeDialog
{
	AppendStyle{font=statusFont},
	Text { name="money", x=41,y=110,w=badgeWidth,h=bsgFontHeight(moneyFont), font=moneyFont },
	Text { name="rank", label="rank_"..gSim.rank, x=41,y=138,w=badgeWidth,h=18, flags=kVAlignTop + kHAlignCenter, },
	Text { name="date", label="#"..bsgDate(gSim.weeks, gSim.days), x=41,y=156,w=badgeWidth,h=18,flags=kVAlignTop + kHAlignCenter, },
	Text { name="score", label="", x=41,y=176, w=badgeWidth,h=118, flags=kVAlignTop + kHAlignCenter, },
--Text { x=0,y=0, w=badgeWidth,h=118, label=noQuestWeeks, flags=kVAlignTop + kHAlignLeft, },
	SetStyle(genButtonStyle),

	Group(medals),
}
